#include <amxmodx>
#include <amxmisc>
#include <cstrike>

//#define DEBUG

#define PLUGIN_NAME 	"Translit"
#define PLUGIN_VERSION 	"0.5.4"
#define PLUGIN_AUTHOR 	"ZmifF"

#define MAX_SIMBOLS 	128
#define SIZE 		10

new g_SayText
new g_TranslitSimbol[MAX_SIMBOLS][SIZE]
new g_EngSimbol[MAX_SIMBOLS][SIZE]
new g_SplitSimbol[SIZE]

public plugin_init ()
{
	register_plugin (PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)

	register_cvar ("amx_client_translit", "1")

	register_dictionary ("translit.txt")

	new lTranslitMode[128], lTranslit[128]
	format (lTranslitMode, 127, "1/0 - %L", LANG_SERVER, "TRANSLIT_MODE")
	format (lTranslit, 127, "%L", LANG_SERVER, "TRANSLIT")

	register_clcmd ("amx_translit", "cmdTranslit", ADMIN_ALL, lTranslitMode)

	register_clcmd ("say","Translit", ADMIN_ALL, lTranslit)
	register_clcmd ("say_team","Translit", ADMIN_ALL, lTranslit)


	g_SayText = get_user_msgid ("SayText")
		
/*
=======================================================================================================================
Read translit table from file
=======================================================================================================================
*/
	new configsDir[64]
	new line, textline[64], len

	get_configsdir (configsDir, 63)
	
	format (configsDir, 63, "%s/translit.ini", configsDir)

	if (!file_exists (configsDir))
	{
		console_print(0, "[AMXX] %L", LANG_SERVER, "NO_FILE", PLUGIN_NAME, configsDir)
		return PLUGIN_HANDLED
	}

	new i=0
	while ((line = read_file (configsDir, line, textline, 63, len)))
	{
		if (len == 0 || equal (textline, ";", 1))
			continue

		parse (textline, g_EngSimbol[i], SIZE, g_SplitSimbol, SIZE, g_TranslitSimbol[i], SIZE)
#if defined DEBUG
		console_print (0, "Loaded simbol translit ^"%s^" into ^"%s^". Split simbol is ^"%s^"", g_EngSimbol[i], g_TranslitSimbol[i], g_SplitSimbol)
#endif
		i++
	}

	return PLUGIN_CONTINUE
}

public cmdTranslit (id)
{
	new translit_mode[2], arg[2]

	get_user_info (id, "translit", translit_mode, 1)
	
	read_argv (1, arg, 2)
	new value = str_to_num (arg)

	switch (value)
	{
		case 0:
		{
			client_cmd (id, "setinfo translit ^"^"")
			client_print (id, print_console, "%L", id, "TRANSLIT_OFF")
			return PLUGIN_HANDLED
		}
		case 1:
		{
			client_cmd (id, "setinfo translit 1")			
			client_print (id, print_console, "%L", id, "TRANSLIT_ON")			
			return PLUGIN_HANDLED
		}
		default:
		{
			if (equal (translit_mode, "1"))
				client_print (id, print_console, "%L", id, "TRANSLIT_ON")
			else
				client_print (id, print_console, "%L", id, "TRANSLIT_OFF")

			return PLUGIN_HANDLED
		}
	}

	return PLUGIN_CONTINUE
}

public Translit (id)
{
	new translit[2]

	if (!get_cvar_num ("amx_client_translit"))
	{
		if (!access (id, ADMIN_CHAT))
			return PLUGIN_CONTINUE
	}

	get_user_info (id, "translit", translit, 1)

	if (!equal (translit, "1"))
		return PLUGIN_CONTINUE

	if (is_user_hltv (id) || is_user_bot (id)) 			// Do not translit bot's and HLTV messages
		return PLUGIN_CONTINUE
/*
=======================================================================================================================
Message
=======================================================================================================================
*/
	new original_message[192], send_message[192]
	new name[32]

	read_args (original_message, 191) 				// Get message sending by user
	remove_quotes (original_message)
#if defined DEBUG
	console_print (0, "Origin message is %s", original_message)
	console_print (0, "Origin message length is %d", strlen (original_message))
#endif
	if (strlen (original_message) < 1)
		return PLUGIN_CONTINUE

	if (contain (original_message, "!") == 0)
		return PLUGIN_CONTINUE

#if defined DEBUG
	add (send_message, 191, "^x01(Translit) ")
#endif
	for (new i=0; i < MAX_SIMBOLS; i++)
	{
		while (contain (original_message, g_EngSimbol[i]) != -1)
		{
			replace (original_message, 191, g_EngSimbol[i], g_TranslitSimbol[i])
#if defined DEBUG
			console_print (0, "Translit ^"%s^" into ^"%s^"", g_EngSimbol[i], g_TranslitSimbol[i])
#endif
		}
	}
/*
=======================================================================================================================
Player's team
=======================================================================================================================
*/
	new say_mode[9]
	new players[32], playersNum
	new CsTeams:team = cs_get_user_team (id)
	new lSpectator[32], lTerrorist[32], lCounterTerrorist[32], lDead[32]

	read_argv (0, say_mode, 8) 					// Determinites say or say_team used

	switch (team)
	{
		case 0:
		{
			if ((equal (say_mode, "say_team")))
			{
#if defined DEBUG
				console_print (0, "User team is UNASSIGNED. Say mode is SAY_TEAM")
#endif
				format (lSpectator, 31, "(%L) ", id, "SPECTATOR")
				add (send_message, 191, lSpectator)

				get_players (players, playersNum, "ce", "SPECTATOR")
			} else {
#if defined DEBUG
				console_print (0, "User team is UNASSIGNED. Say mode is SAY") 
#endif
				get_players (players, playersNum, "bc")
			}
		}
		case 1:
		{
			if (is_user_alive (id))
			{
				if (equal (say_mode, "say_team"))
				{
#if defined DEBUG
					console_print (0, "User team is TERRORIST. User is ALIVE. Say mode is SAY_TEAM") 
#endif
					format (lTerrorist, 31, "(%L) ", id, "TERRORIST")
					add (send_message, 191, lTerrorist)

					get_players (players, playersNum, "ace", "TERRORIST")
				} else {
#if defined DEBUG
					console_print (0, "User team is TERRORIST. User is ALIVE. Say mode is SAY") 
#endif
					get_players (players, playersNum, "ac")
				}
			} else {
				format (lDead, 31, "*%L* ", id, "DEAD")
				add (send_message, 191, lDead)

				if (equal (say_mode, "say_team"))
				{
#if defined DEBUG
					console_print (0, "User team is TERRORIST. User is DEAD. Say mode is SAY_TEAM") 
#endif
					format (lTerrorist, 31, "(%L) ", id, "TERRORIST")
					add (send_message, 191, lTerrorist)

					get_players (players, playersNum, "bce", "TERRORIST")
				} else {
#if defined DEBUG
					console_print (0, "User team is TERRORIST. User is DEAD. Say mode is SAY") 
#endif
					get_players (players, playersNum, "bc")
				}
			}		
		}
		case 2:
		{
			if (is_user_alive (id))
			{
				if (equal (say_mode, "say_team"))
				{
#if defined DEBUG
					console_print (0, "User team is COUNTER_TERRORIST. User is ALIVE. Say mode is SAY_TEAM") 
#endif
					format (lCounterTerrorist, 31, "(%L) ", id, "COUNTERTERRORIST")
					add (send_message, 191, lCounterTerrorist)

					get_players (players, playersNum, "ace", "CT")
				} else {
#if defined DEBUG
					console_print (0, "User team is COUNTER_TERRORIST. User is ALIVE. Say mode is SAY") 
#endif
					get_players (players, playersNum, "ac")
				}
			} else {
				format (lDead, 31, "*%L* ", id, "DEAD")
				add (send_message, 191, lDead)

				if (equal (say_mode, "say_team"))
				{
#if defined DEBUG
					console_print (0, "User team is COUNTER_TERRORIST. User is DEAD. Say mode is SAY_TEAM") 
#endif
					format (lCounterTerrorist, 31, "(%L) ", id, "COUNTERTERRORIST")
					add (send_message, 191, lCounterTerrorist)

					get_players (players, playersNum, "bce", "CT")
				} else {
#if defined DEBUG
					console_print (0, "User team is COUNTER_TERRORIST. User is DEAD. Say mode is SAY") 
#endif
					get_players (players, playersNum, "bc")
				}
			}		
		}
		case 3:
		{
			if ((equal (say_mode, "say_team")))
			{
#if defined DEBUG
				console_print (0, "User team is SPECTATOR. Say mode is SAY_TEAM") 
#endif
				format (lSpectator, 31, "(%L) ", id, "SPECTATOR")
				add (send_message, 191, lSpectator)

				get_players (players, playersNum, "ce", "SPECTATOR")
			} else {
#if defined DEBUG
				console_print (0, "User team is SPECTATOR. Say mode is SAY") 
#endif
				get_players (players, playersNum, "bc")
			}
		}
	}

/*
=======================================================================================================================
Send message
=======================================================================================================================
*/
	get_user_name (id, name, 31)
#if defined DEBUG
	console_print (0, "Send message prefix is ^"%s^"", send_message)
	console_print (0, "Sender name is ^"%s^"", name)
	console_print (0, "Send message is %s", original_message)
	console_print (0, "Send message lenght is %d", strlen (send_message) + strlen (name) + strlen (original_message))
#endif
	format (send_message, 191, "^x01%s^x03%s^x01 :  %s", send_message, name, original_message)

	for (new i=0; i<playersNum; i++)
	{
		message_begin (MSG_ONE, g_SayText, {0, 0, 0}, players[i])
		write_byte (players[i])
		write_string (send_message)
		message_end ()
		client_print (players[i], print_console, send_message)
	}

	return PLUGIN_HANDLED
}